﻿<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Cennik grupowy</title>
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>

<script runat="server">

    public class ParametryContext : ContextBase {
        TowaryModule towaryModule;
        FeatureDefinition grupaCenowa;
        
        public ParametryContext(Context cx)
            : base(cx) {
            towaryModule = TowaryModule.GetInstance(cx.Session);
            GrupaCenowa = towaryModule.DefinicjeCen.StandardowaGrupa;
            Kontrahent = (Soneta.CRM.Kontrahent)cx[typeof(Soneta.CRM.Kontrahent)];
            Magazyn = (Magazyn)cx[typeof(Magazyn)];
        }

        DictionaryItem getFirstElement(FeatureDefinition fd) {
            foreach (DictionaryItem di in fd.DictionaryList)
                return di;
            return null;
        }

        [Caption("Grupa cenowa")]
        [Priority(10)]
        [Required]
        public FeatureDefinition GrupaCenowa {
            get {
                return grupaCenowa;
            }
            set {
                grupaCenowa = value;

                if (value != null && (ElementGrupy == null || ElementGrupy.Category != value.DictionaryKey))
                    ElementGrupy = getFirstElement(value);

                base.OnChanged(EventArgs.Empty);
            }
        }

        public object GetListGrupaCenowa() {
            LookupInfo.EnumerableItem li = new LookupInfo.EnumerableItem(
                "Lista",
                towaryModule.DefinicjeCen.GrupyCenowe,
                new string[] { "Name" });
            li.ComboBox = true;
            return li;
        }

        DictionaryItem elementGrupy;

        [Caption("Element grupy")]
        [Priority(20)]
        [Required]
        public DictionaryItem ElementGrupy {
            get {
                return elementGrupy;
            }
            set {
                elementGrupy = value;
                base.OnChanged(EventArgs.Empty);
            }
        }

        public object GetListElementGrupy() {
            if (GrupaCenowa == null)
                return new DictionaryItem[0];
            LookupInfo.EnumerableItem li = new LookupInfo.EnumerableItem(
                "Lista",
                GrupaCenowa.DictionaryList,
                new string[] { "Value" });
            li.ComboBox = true;
            return li;
        }

        Soneta.CRM.Kontrahent kontrahent;

        [Caption("Kontrahent")]
        [Priority(30)]        
        public Soneta.CRM.Kontrahent Kontrahent {
            get { return kontrahent; }
            set {
                kontrahent = value;
                if (this.GrupaCenowa != null) {
                    string grupaKontrahenta = this.Kontrahent.Features[this.GrupaCenowa].ToString();
                    elementGrupy = null;
                    foreach (DictionaryItem di in GrupaCenowa.DictionaryList) {
                        if (di.Value == grupaKontrahenta) {
                            elementGrupy = di;
                            break;
                        }
                    }
                }
                base.OnChanged(EventArgs.Empty);
            }
        }

        Magazyn magazyn;

        [Caption("Magazyn")]
        [Priority(40)]
        public Magazyn Magazyn {
            get { return magazyn; }
            set {
                magazyn = value;
                base.OnChanged(EventArgs.Empty);
            }
        }
    }

    static ParametryContext parametry;

    [Context]
    public static ParametryContext Parametry {
        get { return parametry; }
        set { parametry = value; }
    }

    Soneta.CRM.Kontrahent kontrahent = null;
    Magazyn magazyn = null;

    void dc_ContextLoad(object sender, EventArgs args) {
        magazyn = Parametry.Magazyn;
        TowaryModule tm = TowaryModule.GetInstance(dc.Session);
        Soneta.Business.View vw = tm.CenyGrupowe.CreateView();
        if (Parametry.Kontrahent != null) {
            kontrahent = Parametry.Kontrahent;
            string grupaKontrahenta = Parametry.Kontrahent.Features[Parametry.GrupaCenowa].ToString();
            vw.Condition &= new FieldCondition.Equal("Grupa.Value", grupaKontrahenta);
            ReportHeader.Title += "|Kontrahent: <strong>" + Parametry.Kontrahent + "</strong>";
            ReportHeader.Title += "|Grupa cen.: <strong>" + grupaKontrahenta + "</strong>";
        }
        else {
            colIndyw.Visible = false;
            colRabat.Visible = false;
            vw.Condition &= new FieldCondition.Equal("Grupa", Parametry.ElementGrupy);
        }
        Grid.DataSource = vw;
    }

    CenaGrupowa cenaGrupowa = null;

    protected void Grid_ItemsGet(object sender, ItemsGetEventArgs args) {
        if (args.Deep != 1) return;
        cenaGrupowa = (CenaGrupowa)args.Row;
        TowaryModule tm = TowaryModule.GetInstance(dc.Session);
        Soneta.Business.View vw = tm.Towary.CreateView();
        if (cenaGrupowa != null && cenaGrupowa.DefinicjaCeny != null && cenaGrupowa.DefinicjaCeny.Table.StandardowaGrupaTowarowa != null) {
            string grupaTowarowa = cenaGrupowa.DefinicjaCeny.Table.StandardowaGrupaTowarowa.Name;
            vw.Condition &= new FieldCondition.Equal("Features." + grupaTowarowa, (string)cenaGrupowa.GrupaTowarowa.Value);
        }
        args.Enumerable = vw;
    }

    class Kontekst : IKontekstCeny, ISessionable {

        readonly Towar t;
        readonly Soneta.CRM.Kontrahent k;
        readonly Magazyn m;

        public Kontekst(Towar t, Soneta.CRM.Kontrahent k, Magazyn m) {
            this.t = t;
            this.k = k;
            this.m = m;
        }

        #region IKontekstCeny Members
        public Towar Towar { get { return t; } }
        public Soneta.CRM.Kontrahent Kontrahent { get { return k; } }
        public DokumentHandlowy Dokument { get { return null; } }
        public PozycjaDokHandlowego Pozycja { get { return null; } }
        public Magazyn Magazyn { get { return m; } }
        #endregion

        #region ISessionable Members
        public Soneta.Business.Session Session { get { return t != null ? t.Session : (k != null ? k.Session : (m != null ? m.Session : null)); } }
        #endregion
    }

    protected void Grid_BeforeRow(object sender, RowEventArgs args) {
        if (cenaGrupowa.DefinicjaCeny == null) {
            args.VisibleRow = false;
            return;
        }
        Towar t = (Towar)args.Row;
        string grupaTowarowa = t.Features[t.Module.DefinicjeCen.StandardowaGrupaTowarowa].ToString();
        ICena c = null;
        bool i = false;
        Percent r = Percent.Blank;
        Kontekst kc = new Kontekst(t, kontrahent, magazyn);
        cenaGrupowa.DefinicjaCeny.Wyliczaj(kc, WyliczenieCeny.PrzeliczenieCeny, out c, out i, out r);
        r = cenaGrupowa.DefinicjaCeny.WyliczajRabat(kc);
        colIndyw.EditValue = i ? "TAK" : "";
        colRabat.EditValue = r;
        colNetto.EditValue = c.Netto;
        colBrutto.EditValue = c.Brutto;
        colIlosc.EditValue = c.StandardowaIlosc;

        if (kontrahent != null)
            Grid.GroupLine = "Grupa tow.: " + grupaTowarowa +
                             ", definicja ceny: " + cenaGrupowa.DefinicjaCeny.Nazwa +
                             ", rabat: " + cenaGrupowa.Rabat;
        else
            Grid.GroupLine = "Grupa cen.: " + cenaGrupowa.Grupa.ToString() +
                             ", grupa tow.: " + grupaTowarowa +
                             ", definicja ceny: " + cenaGrupowa.DefinicjaCeny.Nazwa +
                             ", rabat: " + cenaGrupowa.Rabat;
    }
</script>

<body>
    <form method="post" runat="server">
    <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    <eb:ReportHeader ID="ReportHeader" runat="server" Title="Cennik grupowy"></eb:ReportHeader>
    <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Towary.CenaGrupowa,Soneta.Handel"
        OnItemsGet="Grid_ItemsGet" OnBeforeRow="Grid_BeforeRow">
        <Columns>
            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn Width="15" Align="Left" DataMember="Kod" Caption="Kod" runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn Align="Left" DataMember="Nazwa" Caption="Nazwa" runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn ID="colNetto" Width="15" Align="Right" Caption="Cena netto" runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn ID="colBrutto" Width="15" Align="Right" Caption="Cena brutto" runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn ID="colIlosc" Width="10" Align="Right" Caption="St. ilości" runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn ID="colIndyw" Width="10" Align="Right" Caption="Indywid." runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn ID="colRabat" Width="10" Align="Right" Caption="Rabat" runat="server" EncodeHTML="True"></ea:GridColumn>
        </Columns>
    </ea:Grid>
    <eb:ReportFooter ID="ReportFooter" runat="server">
    </eb:ReportFooter>
    </form>
</body>
</html>

